/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncBin;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="bin", value="_FUNC_(n) - returns n in binary", extended="n is a BIGINT. Returns NULL if n is NULL.\nExample:\n  > SELECT _FUNC_(13) FROM src LIMIT 1\n  '1101'")
@VectorizedExpressions(value={FuncBin.class})
public class UDFBin
extends UDF {
    private final Text result = new Text();
    private final byte[] value = new byte[64];

    public Text evaluate(LongWritable n) {
        if (n == null) {
            return null;
        }
        long num = n.get();
        int len = 0;
        do {
            this.value[this.value.length - ++len] = (byte)(48L + (num & 1L));
        } while ((num >>>= 1) != 0L);
        this.result.set(this.value, this.value.length - len, len);
        return this.result;
    }
}

