/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;

final class UnsafeSorterSpillMerger {
    private int numRecords = 0;
    private final PriorityQueue<UnsafeSorterIterator> priorityQueue;

    UnsafeSorterSpillMerger(RecordComparator recordComparator, PrefixComparator prefixComparator, int numSpills) {
        Comparator comparator = (left, right) -> {
            int prefixComparisonResult = prefixComparator.compare(left.getKeyPrefix(), right.getKeyPrefix());
            if (prefixComparisonResult == 0) {
                return recordComparator.compare(left.getBaseObject(), left.getBaseOffset(), left.getRecordLength(), right.getBaseObject(), right.getBaseOffset(), right.getRecordLength());
            }
            return prefixComparisonResult;
        };
        this.priorityQueue = new PriorityQueue(numSpills, comparator);
    }

    public void addSpillIfNotEmpty(UnsafeSorterIterator spillReader) throws IOException {
        if (spillReader.hasNext()) {
            spillReader.loadNext();
            this.priorityQueue.add(spillReader);
            this.numRecords += spillReader.getNumRecords();
        }
    }

    public UnsafeSorterIterator getSortedIterator() throws IOException {
        return new UnsafeSorterIterator(){
            private UnsafeSorterIterator spillReader;

            @Override
            public int getNumRecords() {
                return UnsafeSorterSpillMerger.this.numRecords;
            }

            @Override
            public long getCurrentPageNumber() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return !UnsafeSorterSpillMerger.this.priorityQueue.isEmpty() || this.spillReader != null && this.spillReader.hasNext();
            }

            @Override
            public void loadNext() throws IOException {
                if (this.spillReader != null && this.spillReader.hasNext()) {
                    this.spillReader.loadNext();
                    UnsafeSorterSpillMerger.this.priorityQueue.add(this.spillReader);
                }
                this.spillReader = (UnsafeSorterIterator)UnsafeSorterSpillMerger.this.priorityQueue.remove();
            }

            @Override
            public Object getBaseObject() {
                return this.spillReader.getBaseObject();
            }

            @Override
            public long getBaseOffset() {
                return this.spillReader.getBaseOffset();
            }

            @Override
            public int getRecordLength() {
                return this.spillReader.getRecordLength();
            }

            @Override
            public long getKeyPrefix() {
                return this.spillReader.getKeyPrefix();
            }
        };
    }
}

