/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client.transport;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.client.Connection;
import org.sparkproject.jetty.client.Result;
import org.sparkproject.jetty.client.transport.HttpDestination;
import org.sparkproject.jetty.client.transport.HttpExchange;
import org.sparkproject.jetty.client.transport.HttpReceiver;
import org.sparkproject.jetty.client.transport.HttpRequest;
import org.sparkproject.jetty.client.transport.HttpSender;
import org.sparkproject.jetty.io.CyclicTimeouts;
import org.sparkproject.jetty.util.Promise;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.thread.AutoLock;

public abstract class HttpChannel
implements CyclicTimeouts.Expirable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannel.class);
    private final AutoLock _lock = new AutoLock();
    private final HttpDestination _destination;
    private HttpExchange _exchange;

    protected HttpChannel(HttpDestination destination) {
        this._destination = destination;
    }

    public void destroy() {
    }

    public HttpDestination getHttpDestination() {
        return this._destination;
    }

    public boolean associate(HttpExchange exchange) {
        boolean result = false;
        boolean abort = true;
        try (AutoLock ignored = this._lock.lock();){
            if (this._exchange == null) {
                abort = false;
                result = exchange.associate(this);
                if (result) {
                    this._exchange = exchange;
                }
            }
        }
        HttpRequest request = exchange.getRequest();
        if (abort) {
            request.abort(new UnsupportedOperationException("Pipelined requests not supported"));
        } else {
            request.setConnection(this.getConnection());
            if (LOG.isDebugEnabled()) {
                LOG.debug("associated {} {} to {}", new Object[]{result, exchange, this});
            }
        }
        return result;
    }

    public boolean disassociate(HttpExchange exchange) {
        boolean result = false;
        try (AutoLock ignored = this._lock.lock();){
            HttpExchange existing = this._exchange;
            this._exchange = null;
            if (existing == exchange) {
                existing.disassociate(this);
                result = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("disassociated {} {} from {}", new Object[]{result, exchange, this});
        }
        return result;
    }

    public HttpExchange getHttpExchange() {
        try (AutoLock ignored = this._lock.lock();){
            HttpExchange httpExchange = this._exchange;
            return httpExchange;
        }
    }

    protected abstract Connection getConnection();

    @Override
    public long getExpireNanoTime() {
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null ? exchange.getExpireNanoTime() : Long.MAX_VALUE;
    }

    protected abstract HttpSender getHttpSender();

    protected abstract HttpReceiver getHttpReceiver();

    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.send(exchange);
        }
    }

    public abstract void send(HttpExchange var1);

    public abstract void release();

    public void proceed(HttpExchange exchange, Runnable proceedAction, Throwable failure) {
        this.getHttpSender().proceed(exchange, proceedAction, failure);
    }

    public void abort(HttpExchange exchange, Throwable requestFailure, Throwable responseFailure, Promise<Boolean> promise) {
        Promise.Completable<Boolean> requestPromise = new Promise.Completable<Boolean>();
        if (requestFailure != null) {
            this.getHttpSender().abort(exchange, requestFailure, requestPromise);
        } else {
            requestPromise.succeeded(false);
        }
        Promise.Completable<Boolean> responsePromise = new Promise.Completable<Boolean>();
        if (responseFailure != null) {
            this.abortResponse(exchange, responseFailure, responsePromise);
        } else {
            responsePromise.succeeded(false);
        }
        Promise.completeWith(promise, requestPromise.thenCombine(responsePromise, (requestAborted, responseAborted) -> requestAborted != false || responseAborted != false));
    }

    public void abortResponse(HttpExchange exchange, Throwable failure, Promise<Boolean> promise) {
        this.getHttpReceiver().abort(exchange, failure, promise);
    }

    public Result exchangeTerminating(HttpExchange exchange, Result result) {
        return result;
    }

    public void exchangeTerminated(HttpExchange exchange, Result result) {
        this.disassociate(exchange);
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getHttpExchange());
    }
}

