/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.ee10.servlet;

import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Locale;
import org.sparkproject.jetty.ee10.servlet.ServletHandler;
import org.sparkproject.jetty.ee10.servlet.ServletHolder;
import org.sparkproject.jetty.ee10.servlet.ServletMapping;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.util.URIUtil;
import org.sparkproject.jetty.util.resource.Resource;

public class JspPropertyGroupServlet
extends GenericServlet {
    public static final String NAME = "__org.eclipse.jetty.servlet.JspPropertyGroupServlet__";
    private final ServletHandler _servletHandler;
    private ServletHolder _dftServlet;
    private ServletHolder _jspServlet;
    private boolean _starJspMapped;

    public JspPropertyGroupServlet(ContextHandler context, ServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    public void init() throws ServletException {
        String jspName = "jsp";
        ServletMapping servletMapping = this._servletHandler.getServletMapping("*.jsp");
        if (servletMapping != null) {
            ServletMapping[] mappings;
            this._starJspMapped = true;
            block0: for (ServletMapping m : mappings = this._servletHandler.getServletMappings()) {
                String[] paths = m.getPathSpecs();
                if (paths == null) continue;
                for (String path : paths) {
                    if (!"*.jsp".equals(path) || NAME.equals(m.getServletName())) continue;
                    servletMapping = m;
                    continue block0;
                }
            }
            jspName = servletMapping.getServletName();
        }
        this._jspServlet = this._servletHandler.getServlet(jspName);
        String defaultName = "default";
        ServletMapping defaultMapping = this._servletHandler.getServletMapping("/");
        if (defaultMapping != null) {
            defaultName = defaultMapping.getServletName();
        }
        this._dftServlet = this._servletHandler.getServlet(defaultName);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        String pathInContext;
        String pathInfo;
        String servletPath;
        if (!(req instanceof HttpServletRequest)) {
            throw new ServletException("Request not HttpServletRequest");
        }
        HttpServletRequest request = (HttpServletRequest)req;
        if (request.getAttribute("jakarta.servlet.include.request_uri") != null) {
            servletPath = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("jakarta.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        if ((pathInContext = URIUtil.addPaths(servletPath, pathInfo)).endsWith("/")) {
            this._dftServlet.getServlet().service(req, res);
        } else if (this._starJspMapped && pathInContext.toLowerCase(Locale.ENGLISH).endsWith(".jsp")) {
            this._jspServlet.getServlet().service(req, res);
        } else {
            Resource resource = null;
            if (resource != null && resource.isDirectory()) {
                this._dftServlet.getServlet().service(req, res);
            } else {
                this._jspServlet.getServlet().service(req, res);
            }
        }
    }
}

