|    | Test Case                 | Spark Type                               | Spark Value                                                               | Python Type                 | Python Value                                                                                          |
|----|---------------------------|------------------------------------------|---------------------------------------------------------------------------|-----------------------------|-------------------------------------------------------------------------------------------------------|
|  0 | byte_values               | tinyint                                  | [-128, 127, 0]                                                            | ['int', 'int', 'int']       | ['-128', '127', '0']                                                                                  |
|  1 | byte_null                 | tinyint                                  | [None, 42]                                                                | ['NAType', 'int8']          | ['<NA>', '42']                                                                                        |
|  2 | short_values              | smallint                                 | [-32768, 32767, 0]                                                        | ['int', 'int', 'int']       | ['-32768', '32767', '0']                                                                              |
|  3 | short_null                | smallint                                 | [None, 123]                                                               | ['NAType', 'int16']         | ['<NA>', '123']                                                                                       |
|  4 | int_values                | int                                      | [-2147483648, 2147483647, 0]                                              | ['int', 'int', 'int']       | ['-2147483648', '2147483647', '0']                                                                    |
|  5 | int_null                  | int                                      | [None, 456]                                                               | ['NAType', 'int32']         | ['<NA>', '456']                                                                                       |
|  6 | long_values               | bigint                                   | [-9223372036854775808, 9223372036854775807, 0]                            | ['int', 'int', 'int']       | ['-9223372036854775808', '9223372036854775807', '0']                                                  |
|  7 | long_null                 | bigint                                   | [None, 789]                                                               | ['NAType', 'int64']         | ['<NA>', '789']                                                                                       |
|  8 | float_values              | float                                    | [0.0, 1.0, 3.140000104904175]                                             | ['float', 'float', 'float'] | ['0.0', '1.0', '3.140000104904175']                                                                   |
|  9 | float_null                | float                                    | [None, 3.140000104904175]                                                 | ['float', 'float']          | ['nan', '3.140000104904175']                                                                          |
| 10 | double_values             | double                                   | [0.0, 1.0, 0.3333333333333333]                                            | ['float', 'float', 'float'] | ['0.0', '1.0', '0.3333333333333333']                                                                  |
| 11 | double_null               | double                                   | [None, 2.71]                                                              | ['float', 'float']          | ['nan', '2.71']                                                                                       |
| 12 | decimal_values            | decimal(3,2)                             | [Decimal('5.35'), Decimal('1.23')]                                        | ['Decimal', 'Decimal']      | ['5.35', '1.23']                                                                                      |
| 13 | decimal_null              | decimal(3,2)                             | [None, Decimal('9.99')]                                                   | ['NoneType', 'Decimal']     | ['None', '9.99']                                                                                      |
| 14 | string_values             | string                                   | ['abc', '', 'hello']                                                      | ['str', 'str', 'str']       | ['abc', '', 'hello']                                                                                  |
| 15 | string_null               | string                                   | [None, 'test']                                                            | ['NoneType', 'str']         | ['None', 'test']                                                                                      |
| 16 | binary_values             | binary                                   | [b'abc', b'', b'ABC']                                                     | ['bytes', 'bytes', 'bytes'] | ["b'abc'", "b''", "b'ABC'"]                                                                           |
| 17 | binary_null               | binary                                   | [None, b'test']                                                           | ['NoneType', 'bytes']       | ['None', "b'test'"]                                                                                   |
| 18 | boolean_values            | boolean                                  | [True, False]                                                             | ['bool', 'bool']            | ['True', 'False']                                                                                     |
| 19 | boolean_null              | boolean                                  | [None, True]                                                              | ['NoneType', 'bool']        | ['None', 'True']                                                                                      |
| 20 | date_values               | date                                     | [datetime.date(2020, 2, 2), datetime.date(1970, 1, 1)]                    | ['date', 'date']            | ['2020-02-02', '1970-01-01']                                                                          |
| 21 | date_null                 | date                                     | [None, datetime.date(2023, 1, 1)]                                         | ['NoneType', 'date']        | ['None', '2023-01-01']                                                                                |
| 22 | timestamp_values          | timestamp                                | [datetime.datetime(2020, 2, 2, 12, 15, 16, 123000)]                       | ['Timestamp']               | ['2020-02-02 12:15:16.123000']                                                                        |
| 23 | timestamp_null            | timestamp                                | [None, datetime.datetime(2023, 1, 1, 12, 0)]                              | ['NaTType', 'Timestamp']    | ['NaT', '2023-01-01 12:00:00']                                                                        |
| 24 | array_int_values          | array<int>                               | [[1, 2, 3], [], [1, None, 3]]                                             | ['list', 'list', 'list']    | ['[1, 2, 3]', '[]', '[1, None, 3]']                                                                   |
| 25 | array_int_null            | array<int>                               | [None, [4, 5, 6]]                                                         | ['NoneType', 'list']        | ['None', '[np.int32(4), np.int32(5), np.int32(6)]']                                                   |
| 26 | map_str_int_values        | map<string,int>                          | [{'world': 2, 'hello': 1}, {}]                                            | ['dict', 'dict']            | ["{'world': 2, 'hello': 1}", '{}']                                                                    |
| 27 | map_str_int_null          | map<string,int>                          | [None, {'test': 123}]                                                     | ['NoneType', 'dict']        | ['None', "{'test': 123}"]                                                                             |
| 28 | struct_int_str_values     | struct<a1:int,a2:string>                 | [Row(a1=1, a2='hello'), Row(a1=2, a2='world')]                            | ['Row', 'Row']              | ["Row(a1=1, a2='hello')", "Row(a1=2, a2='world')"]                                                    |
| 29 | struct_int_str_null       | struct<a1:int,a2:string>                 | [None, Row(a1=99, a2='test')]                                             | ['NoneType', 'Row']         | ['None', "Row(a1=99, a2='test')"]                                                                     |
| 30 | array_array_int           | array<array<int>>                        | [[[1, 2, 3]], [[1], [2, 3]]]                                              | ['list', 'list']            | ['[[np.int32(1), np.int32(2), np.int32(3)]]', '[[np.int32(1)], [np.int32(2), np.int32(3)]]']          |
| 31 | array_map_str_int         | array<map<string,int>>                   | [[{'world': 2, 'hello': 1}], [{'a': 1}, {'b': 2}]]                        | ['list', 'list']            | ["[{'world': 2, 'hello': 1}]", "[{'a': 1}, {'b': 2}]"]                                                |
| 32 | array_struct_int_str      | array<struct<a1:int,a2:string>>          | [[Row(a1=1, a2='hello')], [Row(a1=1, a2='hello'), Row(a1=2, a2='world')]] | ['list', 'list']            | ["[Row(a1=1, a2='hello')]", "[Row(a1=1, a2='hello'), Row(a1=2, a2='world')]"]                         |
| 33 | map_int_array_int         | map<int,array<int>>                      | [{1: [1, 2, 3]}, {1: [1], 2: [2, 3]}]                                     | ['dict', 'dict']            | ['{1: [np.int32(1), np.int32(2), np.int32(3)]}', '{1: [np.int32(1)], 2: [np.int32(2), np.int32(3)]}'] |
| 34 | map_int_map_str_int       | map<int,map<string,int>>                 | [{1: {'world': 2, 'hello': 1}}]                                           | ['dict']                    | ["{1: {'world': 2, 'hello': 1}}"]                                                                     |
| 35 | map_int_struct_int_str    | map<int,struct<a1:int,a2:string>>        | [{1: Row(a1=1, a2='hello')}]                                              | ['dict']                    | ["{1: Row(a1=1, a2='hello')}"]                                                                        |
| 36 | struct_int_array_int      | struct<a:int,b:array<int>>               | [Row(a=1, b=[1, 2, 3])]                                                   | ['Row']                     | ['Row(a=1, b=[np.int32(1), np.int32(2), np.int32(3)])']                                               |
| 37 | struct_int_map_str_int    | struct<a:int,b:map<string,int>>          | [Row(a=1, b={'world': 2, 'hello': 1})]                                    | ['Row']                     | ["Row(a=1, b={'world': 2, 'hello': 1})"]                                                              |
| 38 | struct_int_struct_int_str | struct<a:int,b:struct<a1:int,a2:string>> | [Row(a=1, b=Row(a1=1, a2='hello'))]                                       | ['Row']                     | ["Row(a=1, b=Row(a1=1, a2='hello'))"]                                                                 |