/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http.openid;

import java.time.Instant;
import java.util.List;
import org.jose4j.jwt.consumer.Validator;

public class JwtValidators {
    public static final Validator EXPIRATION = context -> {
        long now;
        long exp = (Long)context.getJwtClaims().getClaimValue("exp", Long.class);
        if (exp < (now = Instant.now().getEpochSecond())) {
            return "exp is not in the future (exp=" + exp + ", current time is " + now + ")";
        }
        return null;
    };
    public static final Validator ISSUED_AT = context -> {
        long now;
        long iat = (Long)context.getJwtClaims().getClaimValue("iat", Long.class);
        if (iat > (now = Instant.now().getEpochSecond())) {
            return "iat is in the future (iat=" + iat + ", current time is " + now + ")";
        }
        return null;
    };
    public static final Validator NOT_BEOFRE = context -> {
        Long nbf = (Long)context.getJwtClaims().getClaimValue("nbf", Long.class);
        if (nbf == null) {
            return null;
        }
        long now = Instant.now().getEpochSecond();
        if (nbf > now) {
            return "nbf is in the future (nbf=" + nbf + ", current time is " + now + ")";
        }
        return null;
    };

    public static Validator nonce(String nonce) {
        return context -> {
            String nonceClaim = context.getJwtClaims().getStringClaimValue("nonce");
            if (!nonce.equals(nonceClaim)) {
                return "nonce value does not match the stored value (expected " + nonce + " but got " + nonceClaim + ")";
            }
            return null;
        };
    }

    public static Validator azp(String clientId) {
        return context -> {
            List aud = context.getJwtClaims().getAudience();
            String azp = context.getJwtClaims().getStringClaimValue("azp");
            if (aud.size() > 1 && azp == null) {
                return "aud has " + aud.size() + " entries (" + String.join((CharSequence)", ", aud) + ") but no azp claim is present";
            }
            if (azp != null && !clientId.equals(azp)) {
                return "azp is not equal to configured clientId (got " + azp + " but expected " + clientId + ")";
            }
            return null;
        };
    }
}

