/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.callbacks;

import io.smallrye.openapi.api.models.callbacks.CallbackImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.PathItemIO;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.ReferenceType;
import io.smallrye.openapi.runtime.io.callbacks.CallbackOperationIO;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class CallbackIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Callback, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_OPERATIONS = "operations";
    private static final String PROP_CALLBACK_URL_EXPRESSION = "callbackUrlExpression";
    private final CallbackOperationIO<V, A, O, AB, OB> callbackOperationIO;
    private final PathItemIO<V, A, O, AB, OB> pathItemIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public CallbackIO(IOContext<V, A, O, AB, OB> context, ContentIO<V, A, O, AB, OB> contentIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.CALLBACK, DotName.createSimple(Callback.class));
        this.callbackOperationIO = new CallbackOperationIO<V, A, O, AB, OB>(context, contentIO, this, extensionIO);
        this.pathItemIO = new PathItemIO<V, A, O, AB, OB>(context, this.callbackOperationIO, contentIO, extensionIO);
        this.extensionIO = extensionIO;
    }

    @Override
    public Callback read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@Callback");
        CallbackImpl callback = new CallbackImpl();
        callback.setRef(ReferenceType.CALLBACK.refValue(annotation));
        Optional.ofNullable(this.value(annotation, PROP_OPERATIONS)).map(AnnotationInstance[].class::cast).map(this.pathItemIO::read).ifPresent(pathItem -> callback.addPathItem((String)this.value(annotation, PROP_CALLBACK_URL_EXPRESSION), (PathItem)pathItem));
        callback.setExtensions(this.extensionIO.readExtensible(annotation));
        return callback;
    }

    @Override
    public Callback readObject(O node) {
        IoLogging.logger.singleJsonNode("Callback");
        CallbackImpl callback = new CallbackImpl();
        callback.setRef(this.readReference(node));
        this.jsonIO().properties(node).stream().filter(CallbackIO.not(ExtensionIO::isExtension)).filter(CallbackIO.not(this::isReference)).filter(property -> this.jsonIO().isObject(property.getValue())).map(property -> CallbackIO.entry((String)property.getKey(), (PathItem)this.pathItemIO.readValue(property.getValue()))).forEach(pathItem -> callback.addPathItem((String)pathItem.getKey(), (PathItem)pathItem.getValue()));
        this.extensionIO.readMap(node).forEach((arg_0, arg_1) -> ((Callback)callback).addExtension(arg_0, arg_1));
        return callback;
    }

    @Override
    public Optional<O> write(Callback model) {
        return this.optionalJsonObject(model).map(node -> {
            if (this.isReference((Reference<?>)model)) {
                this.setReference(node, (Reference<?>)model);
            } else {
                Optional.ofNullable(model.getPathItems()).ifPresent(items -> items.forEach((key, value) -> this.setIfPresent(node, (String)key, this.pathItemIO.write((PathItem)value))));
                this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

