/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;

public class OperationImpl
extends ExtensibleImpl<Operation>
implements Operation,
ModelImpl {
    private List<String> tags;
    private String summary;
    private String description;
    private ExternalDocumentation externalDocs;
    private String operationId;
    private List<Parameter> parameters;
    private RequestBody requestBody;
    private APIResponses responses;
    private Map<String, Callback> callbacks;
    private Boolean deprecated;
    private List<SecurityRequirement> security;
    private List<Server> servers;
    private String methodRef;

    public OperationImpl() {
    }

    public OperationImpl(String methodRef) {
        this.methodRef = methodRef;
    }

    public List<String> getTags() {
        return ModelUtil.unmodifiableList(this.tags);
    }

    public void setTags(List<String> tags) {
        this.tags = ModelUtil.replace(tags);
    }

    public Operation addTag(String tag) {
        this.tags = ModelUtil.add(tag, this.tags);
        return this;
    }

    public void removeTag(String tag) {
        ModelUtil.remove(this.tags, tag);
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public List<Parameter> getParameters() {
        return ModelUtil.unmodifiableList(this.parameters);
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = ModelUtil.replace(parameters);
    }

    public Operation addParameter(Parameter parameter) {
        this.parameters = ModelUtil.add(parameter, this.parameters);
        return this;
    }

    public void removeParameter(Parameter parameter) {
        ModelUtil.remove(this.parameters, parameter);
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public APIResponses getResponses() {
        return this.responses;
    }

    public void setResponses(APIResponses responses) {
        this.responses = responses;
    }

    public Map<String, Callback> getCallbacks() {
        return ModelUtil.unmodifiableMap(this.callbacks);
    }

    public void setCallbacks(Map<String, Callback> callbacks) {
        this.callbacks = ModelUtil.replace(callbacks);
    }

    public Operation addCallback(String key, Callback callback) {
        this.callbacks = ModelUtil.add(key, callback, this.callbacks);
        return this;
    }

    public void removeCallback(String key) {
        ModelUtil.remove(this.callbacks, key);
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public List<SecurityRequirement> getSecurity() {
        return ModelUtil.unmodifiableList(this.security);
    }

    public void setSecurity(List<SecurityRequirement> security) {
        this.security = ModelUtil.replace(security);
    }

    public Operation addSecurityRequirement(SecurityRequirement securityRequirement) {
        this.security = ModelUtil.add(securityRequirement, this.security);
        return this;
    }

    public void removeSecurityRequirement(SecurityRequirement securityRequirement) {
        ModelUtil.remove(this.security, securityRequirement);
    }

    public List<Server> getServers() {
        return ModelUtil.unmodifiableList(this.servers);
    }

    public void setServers(List<Server> servers) {
        this.servers = ModelUtil.replace(servers);
    }

    public Operation addServer(Server server) {
        this.servers = ModelUtil.add(server, this.servers);
        return this;
    }

    public void removeServer(Server server) {
        ModelUtil.remove(this.servers, server);
    }

    public String getMethodRef() {
        return this.methodRef;
    }

    public void setMethodRef(String methodRef) {
        this.methodRef = methodRef;
    }

    public static String getMethodRef(Operation operation) {
        return operation instanceof OperationImpl ? ((OperationImpl)operation).getMethodRef() : null;
    }
}

