/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.tomee.loader.OpenEJBListener;

public class TomEEListener
implements LifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(TomEEListener.class.getName());
    private static final Method delegateMethod;
    private final Object delegate;

    public TomEEListener() {
        OpenEJBListener instance = null;
        if (this.tomeeLibAreInTomcatLibs()) {
            try {
                instance = TomEEListener.class.getClassLoader().loadClass("org.apache.tomee.catalina.ServerListener").newInstance();
            }
            catch (Exception e) {
                LOGGER.severe("can't instantiate ServerListener");
            }
        }
        if (instance == null) {
            instance = new OpenEJBListener();
        }
        this.delegate = instance;
    }

    private boolean tomeeLibAreInTomcatLibs() {
        File lib = new File(System.getProperty("catalina.home"), "lib");
        if (lib.exists()) {
            File[] files = lib.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.startsWith("openejb-core") && name.endsWith(".jar");
                }
            });
            return files != null && files.length > 0;
        }
        return false;
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            delegateMethod.invoke(this.delegate, lifecycleEvent);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "error invoking {0} for {1}", new Object[]{delegateMethod.getName(), lifecycleEvent});
        }
    }

    static {
        Method mtd = null;
        try {
            mtd = LifecycleListener.class.getMethod("lifecycleEvent", LifecycleEvent.class);
        }
        catch (Exception e) {
            LOGGER.severe("can't get lifecycleEvent method from LifecycleListener");
        }
        delegateMethod = mtd;
    }
}

