/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.common;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.handler.api.ServerReadHandler;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandlerWrapper;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.apache.uniffle.storage.request.CreateShuffleWriteHandlerRequest;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;

public abstract class AbstractStorage
implements Storage {
    private Map<String, Map<String, ShuffleWriteHandler>> writerHandlers = JavaUtils.newConcurrentMap();
    private Map<String, Map<String, CreateShuffleWriteHandlerRequest>> requests = JavaUtils.newConcurrentMap();
    private Map<String, Map<String, ServerReadHandler>> readerHandlers = JavaUtils.newConcurrentMap();

    abstract ShuffleWriteHandler newWriteHandler(CreateShuffleWriteHandlerRequest var1);

    @Override
    public ShuffleWriteHandlerWrapper getOrCreateWriteHandler(CreateShuffleWriteHandlerRequest request) {
        this.writerHandlers.computeIfAbsent(request.getAppId(), key -> JavaUtils.newConcurrentMap());
        this.requests.computeIfAbsent(request.getAppId(), key -> JavaUtils.newConcurrentMap());
        Map<String, ShuffleWriteHandler> map = this.writerHandlers.get(request.getAppId());
        String partitionKeyExceptAppId = AbstractStorage.generatePartitionKeyExceptAppId(request.getShuffleId(), request.getStartPartition());
        boolean isNewlyCreated = false;
        if (!map.containsKey(partitionKeyExceptAppId)) {
            isNewlyCreated = true;
        }
        map.computeIfAbsent(partitionKeyExceptAppId, key -> this.newWriteHandler(request));
        Map<String, CreateShuffleWriteHandlerRequest> requestMap = this.requests.get(request.getAppId());
        requestMap.putIfAbsent(partitionKeyExceptAppId, request);
        return new ShuffleWriteHandlerWrapper(map.get(partitionKeyExceptAppId), isNewlyCreated);
    }

    @Override
    public ServerReadHandler getOrCreateReadHandler(CreateShuffleReadHandlerRequest request) {
        this.readerHandlers.computeIfAbsent(request.getAppId(), key -> JavaUtils.newConcurrentMap());
        Map<String, ServerReadHandler> map = this.readerHandlers.get(request.getAppId());
        int[] range = ShuffleStorageUtils.getPartitionRange(request.getPartitionId(), request.getPartitionNumPerRange(), request.getPartitionNum());
        String partitionKeyExceptAppId = AbstractStorage.generatePartitionKeyExceptAppId(request.getShuffleId(), range[0]);
        map.computeIfAbsent(partitionKeyExceptAppId, key -> this.newReadHandler(request));
        return map.get(partitionKeyExceptAppId);
    }

    protected abstract ServerReadHandler newReadHandler(CreateShuffleReadHandlerRequest var1);

    @Override
    public boolean containsWriteHandler(String appId) {
        return this.writerHandlers.containsKey(appId);
    }

    public boolean containsWriteHandler(String appId, int shuffleId, int partition) {
        Map<String, ShuffleWriteHandler> map = this.writerHandlers.get(appId);
        if (map == null || map.isEmpty()) {
            return false;
        }
        String partitionKeyExceptAppId = AbstractStorage.generatePartitionKeyExceptAppId(shuffleId, partition);
        return map.containsKey(partitionKeyExceptAppId);
    }

    public static String generatePartitionKeyExceptAppId(Integer shuffleId, Integer partition) {
        return String.join((CharSequence)"/", String.valueOf(shuffleId), String.valueOf(partition));
    }

    @Override
    public void removeHandlers(String appId) {
        this.writerHandlers.remove(appId);
        this.readerHandlers.remove(appId);
        this.requests.remove(appId);
    }

    @VisibleForTesting
    public int getHandlerSize() {
        return this.writerHandlers.size();
    }
}

