/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.access.checker;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.common.ReconfigurableConfManager;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.coordinator.AccessManager;
import org.apache.uniffle.coordinator.ClusterManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.access.AccessCheckResult;
import org.apache.uniffle.coordinator.access.AccessInfo;
import org.apache.uniffle.coordinator.access.checker.AbstractAccessChecker;
import org.apache.uniffle.coordinator.metric.CoordinatorMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessClusterLoadChecker
extends AbstractAccessChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AccessClusterLoadChecker.class);
    private final ClusterManager clusterManager;
    private final double memoryPercentThreshold;
    private final int availableServerNumThreshold;
    private volatile ReconfigurableConfManager.Reconfigurable<Integer> defaultRequiredShuffleServerNumber;

    public AccessClusterLoadChecker(AccessManager accessManager) throws Exception {
        super(accessManager);
        this.clusterManager = accessManager.getClusterManager();
        CoordinatorConf conf = accessManager.getCoordinatorConf();
        this.memoryPercentThreshold = conf.getDouble(CoordinatorConf.COORDINATOR_ACCESS_LOADCHECKER_MEMORY_PERCENTAGE);
        this.availableServerNumThreshold = conf.getInteger(CoordinatorConf.COORDINATOR_ACCESS_LOADCHECKER_SERVER_NUM_THRESHOLD, -1);
        this.defaultRequiredShuffleServerNumber = conf.getReconfigurableConf(CoordinatorConf.COORDINATOR_SHUFFLE_NODES_MAX);
    }

    @Override
    public AccessCheckResult check(AccessInfo accessInfo) {
        Set<String> tags = accessInfo.getTags();
        List<ServerNode> servers = this.clusterManager.getServerList(tags);
        int size = (int)servers.stream().filter(serverNode -> serverNode.getStatus().equals((Object)ServerStatus.ACTIVE)).filter(this::checkMemory).count();
        if (this.availableServerNumThreshold != -1 && size >= this.availableServerNumThreshold) {
            return new AccessCheckResult(true, "SUCCESS");
        }
        if (this.availableServerNumThreshold == -1) {
            String requiredNodesNumRaw = accessInfo.getExtraProperties().get("access_info_required_shuffle_nodes_num");
            int requiredNodesNum = (Integer)this.defaultRequiredShuffleServerNumber.get();
            if (StringUtils.isNotEmpty((CharSequence)requiredNodesNumRaw) && Integer.parseInt(requiredNodesNumRaw) > 0) {
                requiredNodesNum = Integer.parseInt(requiredNodesNumRaw);
            }
            if (size >= requiredNodesNum) {
                return new AccessCheckResult(true, "SUCCESS");
            }
        }
        String msg = String.format("Denied by AccessClusterLoadChecker accessInfo[%s], total %s nodes, %s available nodes, memory percent threshold %s, available num threshold %s.", accessInfo, servers.size(), size, this.memoryPercentThreshold, this.availableServerNumThreshold);
        LOG.warn(msg);
        CoordinatorMetrics.counterTotalLoadDeniedRequest.inc();
        return new AccessCheckResult(false, msg);
    }

    private boolean checkMemory(ServerNode serverNode) {
        double total;
        double availableMemory = serverNode.getAvailableMemory();
        double availablePercent = availableMemory / ((total = (double)serverNode.getTotalMemory()) / 100.0);
        return Double.compare(availablePercent, this.memoryPercentThreshold) >= 0;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public double getMemoryPercentThreshold() {
        return this.memoryPercentThreshold;
    }

    public int getAvailableServerNumThreshold() {
        return this.availableServerNumThreshold;
    }

    @Override
    public void close() {
    }
}

