/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import org.apache.spark.SparkConf;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.uniffle.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegationRssShuffleManagerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DelegationRssShuffleManagerUtils.class);

    public static String acquireAccessId(SparkConf sparkConf) {
        String providerKey;
        String accessId = sparkConf.get(RssSparkConfig.RSS_ACCESS_ID.key(), "").trim();
        if (StringUtils.isEmpty(accessId) && StringUtils.isNotEmpty(providerKey = sparkConf.get(RssSparkConfig.RSS_ACCESS_ID_PROVIDER_KEY.key(), ""))) {
            accessId = sparkConf.get(providerKey, "");
            LOG.info("Get access id {} from provider key: {}", (Object)accessId, (Object)providerKey);
        }
        return accessId;
    }
}

