/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.lang.reflect.Field;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.task.reduce.InMemoryMapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.OnDiskMapOutput;
import org.apache.uniffle.common.exception.RssException;

public class RssBypassWriter {
    public static void write(MapOutput mapOutput, byte[] buffer) {
        if (!(mapOutput instanceof InMemoryMapOutput)) {
            if (mapOutput instanceof OnDiskMapOutput) {
                throw new IllegalStateException("RSS does not support OnDiskMapOutput as shuffle ouput, try to reduce mapreduce.reduce.shuffle.memory.limit.percent");
            }
            throw new IllegalStateException("Merger reserve unknown type of MapOutput: " + mapOutput.getClass().getCanonicalName());
        }
        InMemoryMapOutput inMemoryMapOutput = (InMemoryMapOutput)mapOutput;
        CodecPool.returnDecompressor((Decompressor)RssBypassWriter.getDecompressor(inMemoryMapOutput));
        RssBypassWriter.write(inMemoryMapOutput, buffer);
    }

    private static void write(InMemoryMapOutput inMemoryMapOutput, byte[] buffer) {
        byte[] memory = inMemoryMapOutput.getMemory();
        System.arraycopy(buffer, 0, memory, 0, buffer.length);
    }

    static Decompressor getDecompressor(InMemoryMapOutput inMemoryMapOutput) {
        try {
            Class<?> clazz = Class.forName(InMemoryMapOutput.class.getName());
            Field deCompressorField = clazz.getDeclaredField("decompressor");
            deCompressorField.setAccessible(true);
            Decompressor decompressor = (Decompressor)deCompressorField.get(inMemoryMapOutput);
            return decompressor;
        }
        catch (Exception e) {
            throw new RssException("Get Decompressor fail " + e.getMessage());
        }
    }
}

