/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.InMemoryMapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.RssInMemoryRemoteMerger;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssRemoteMergeManagerImpl<K, V>
extends MergeManagerImpl<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(RssRemoteMergeManagerImpl.class);
    private final String appId;
    private final TaskAttemptID reduceId;
    private final JobConf jobConf;
    Set<InMemoryMapOutput<K, V>> inMemoryMapOutputs = new TreeSet<InMemoryMapOutput<K, V>>(new MapOutput.MapOutputComparator());
    private final RssInMemoryRemoteMerger<K, V> inMemoryMerger;
    Set<Path> onHDFSMapOutputs = new TreeSet<Path>();
    @VisibleForTesting
    final long memoryLimit;
    private long usedMemory;
    private long commitMemory;
    private final long mergeThreshold;
    private final Reporter reporter;
    private final ExceptionReporter exceptionReporter;
    private final Class<? extends Reducer> combinerClass;
    private final Task.CombineOutputCollector<K, V> combineCollector;
    private final Counters.Counter spilledRecordsCounter;
    private final Counters.Counter reduceCombineInputCounter;
    private final Counters.Counter mergedMapOutputsCounter;
    private final CompressionCodec codec;
    private final Progress mergePhase;
    private String basePath;
    private FileSystem remoteFS;

    public RssRemoteMergeManagerImpl(String appId, TaskAttemptID reduceId, JobConf jobConf, String basePath, int replication, int retries, FileSystem localFS, LocalDirAllocator localDirAllocator, Reporter reporter, CompressionCodec codec, Class<? extends Reducer> combinerClass, Task.CombineOutputCollector<K, V> combineCollector, Counters.Counter spilledRecordsCounter, Counters.Counter reduceCombineInputCounter, Counters.Counter mergedMapOutputsCounter, ExceptionReporter exceptionReporter, Progress mergePhase, MapOutputFile mapOutputFile, JobConf remoteConf) {
        super(reduceId, jobConf, localFS, localDirAllocator, reporter, codec, combinerClass, combineCollector, spilledRecordsCounter, reduceCombineInputCounter, mergedMapOutputsCounter, exceptionReporter, mergePhase, mapOutputFile);
        this.appId = appId;
        this.reduceId = reduceId;
        this.jobConf = jobConf;
        this.exceptionReporter = exceptionReporter;
        this.mergePhase = mergePhase;
        this.reporter = reporter;
        this.codec = codec;
        this.combinerClass = combinerClass;
        this.combineCollector = combineCollector;
        this.reduceCombineInputCounter = reduceCombineInputCounter;
        this.spilledRecordsCounter = spilledRecordsCounter;
        this.mergedMapOutputsCounter = mergedMapOutputsCounter;
        try {
            remoteConf.setInt("dfs.replication", replication);
            remoteConf.setInt("dfs.client.block.write.retries", retries);
            this.remoteFS = HadoopFilesystemProvider.getFilesystem(new Path(basePath), (Configuration)remoteConf);
        }
        catch (Exception e) {
            throw new RssException("Cannot init remoteFS on path:" + basePath);
        }
        this.basePath = basePath;
        float maxInMemCopyUse = jobConf.getFloat("mapreduce.reduce.shuffle.input.buffer.percent", 0.7f);
        if ((double)maxInMemCopyUse > 1.0 || (double)maxInMemCopyUse < 0.0) {
            throw new IllegalArgumentException("Invalid value for mapreduce.reduce.shuffle.input.buffer.percent: " + maxInMemCopyUse);
        }
        this.memoryLimit = (long)((float)jobConf.getLong("mapreduce.reduce.memory.totalbytes", Runtime.getRuntime().maxMemory()) * maxInMemCopyUse);
        this.usedMemory = 0L;
        this.commitMemory = 0L;
        this.mergeThreshold = (long)((float)this.memoryLimit * jobConf.getFloat("mapreduce.reduce.shuffle.merge.percent", 0.66f));
        LOG.info("MergerManager: memoryLimit={}, mergeThreshold={}", (Object)this.memoryLimit, (Object)this.mergeThreshold);
        this.inMemoryMerger = this.createRssInMemoryMerger();
        this.inMemoryMerger.start();
    }

    protected RssInMemoryRemoteMerger<K, V> createRssInMemoryMerger() {
        return new RssInMemoryRemoteMerger<K, V>(this, this.jobConf, this.remoteFS, new Path(this.basePath, this.appId), this.reduceId.toString(), this.codec, (Progressable)this.reporter, this.spilledRecordsCounter, this.combinerClass, this.exceptionReporter, this.combineCollector, this.reduceCombineInputCounter, this.mergedMapOutputsCounter);
    }

    public void waitForResource() throws InterruptedException {
        this.inMemoryMerger.waitForMerge();
    }

    public synchronized MapOutput<K, V> reserve(TaskAttemptID mapId, long requestedSize, int fetcher) throws IOException {
        if (this.usedMemory > this.memoryLimit) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(mapId + ": Stalling shuffle since usedMemory (" + this.usedMemory + ") is greater than memoryLimit (" + this.memoryLimit + "). CommitMemory is (" + this.commitMemory + ")");
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(mapId + ": Proceeding with shuffle since usedMemory (" + this.usedMemory + ") is lesser than memoryLimit (" + this.memoryLimit + ").CommitMemory is (" + this.commitMemory + ")");
        }
        this.usedMemory += requestedSize;
        return new InMemoryMapOutput((Configuration)this.jobConf, mapId, (MergeManagerImpl)this, (int)requestedSize, this.codec, true);
    }

    synchronized void unreserve(long size) {
        this.usedMemory -= size;
    }

    public synchronized void closeInMemoryFile(InMemoryMapOutput<K, V> mapOutput) {
        this.inMemoryMapOutputs.add(mapOutput);
        LOG.info("closeInMemoryFile -> map-output of size: " + mapOutput.getSize() + ", inMemoryMapOutputs.size() -> " + this.inMemoryMapOutputs.size() + ", commitMemory -> " + this.commitMemory + ", usedMemory ->" + this.usedMemory);
        this.commitMemory += mapOutput.getSize();
        if (this.commitMemory >= this.mergeThreshold) {
            LOG.info("Starting inMemoryMerger's merge since commitMemory=" + this.commitMemory + " > mergeThreshold=" + this.mergeThreshold + ". Current usedMemory=" + this.usedMemory);
            this.inMemoryMergedMapOutputs.clear();
            this.inMemoryMerger.startMerge(this.inMemoryMapOutputs);
            this.commitMemory = 0L;
        }
    }

    public synchronized void closeOnHDFSFile(Path file) {
        this.onHDFSMapOutputs.add(file);
    }

    public synchronized void closeInMemoryMergedFile(InMemoryMapOutput<K, V> mapOutput) {
        throw new IllegalStateException("closeInMemoryMergedFile is unsupported for rss merger");
    }

    public synchronized void closeOnDiskFile(MergeManagerImpl.CompressAwarePath file) {
        throw new IllegalStateException("closeOnDiskFile is unsupported for rss merger");
    }

    public RawKeyValueIterator close() throws Throwable {
        this.inMemoryMerger.startMerge(this.inMemoryMapOutputs);
        this.inMemoryMerger.close();
        if (!this.inMemoryMapOutputs.isEmpty()) {
            throw new RssException("InMemoryMapOutputs should be empty");
        }
        return this.finalMerge();
    }

    private RawKeyValueIterator finalMerge() throws IOException {
        Class keyClass = this.jobConf.getMapOutputKeyClass();
        Class valueClass = this.jobConf.getMapOutputValueClass();
        RawComparator comparator = this.jobConf.getOutputKeyComparator();
        return Merger.merge((Configuration)this.jobConf, (FileSystem)this.remoteFS, (Class)keyClass, (Class)valueClass, (CompressionCodec)this.codec, (Path[])this.onHDFSMapOutputs.toArray(new Path[this.onHDFSMapOutputs.size()]), (boolean)true, (int)Integer.MAX_VALUE, (Path)new Path("reduceId"), (RawComparator)comparator, (Progressable)this.reporter, (Counters.Counter)this.spilledRecordsCounter, null, null, null);
    }
}

