/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.RssTezUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.ProgressFailedException;
import org.apache.tez.runtime.library.api.IOInterruptedException;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.ValuesIterator;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.RssShuffle;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class RssOrderedGroupedKVInput
extends AbstractLogicalInput {
    static final Logger LOG = LoggerFactory.getLogger(RssOrderedGroupedKVInput.class);
    protected TezRawKeyValueIterator rawIter = null;
    protected Configuration conf;
    protected RssShuffle shuffle;
    protected MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private int shuffleId;
    private ApplicationAttemptId applicationAttemptId;
    private final BlockingQueue<Event> pendingEvents = new LinkedBlockingQueue<Event>();
    private long firstEventReceivedTime = -1L;
    protected ValuesIterator vIter;
    private TezCounter inputKeyCounter;
    private TezCounter inputValueCounter;
    private TezCounter shuffledInputs;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private static final Set<String> CONF_KEYS = new HashSet<String>();

    public RssOrderedGroupedKVInput(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
    }

    public synchronized List<Event> initialize() throws IOException {
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        if (this.getNumPhysicalInputs() == 0) {
            this.getContext().requestInitialMemory(0L, null);
            this.isStarted.set(true);
            this.getContext().inputIsReady();
            LOG.info("input fetch not required since there are 0 physical inputs for input vertex: " + this.getContext().getSourceVertexName());
            return Collections.emptyList();
        }
        long initialMemoryRequest = RssShuffle.getInitialMemoryRequirement(this.conf, this.getContext().getTotalMemoryAvailableToTask());
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        this.getContext().requestInitialMemory(initialMemoryRequest, (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        this.inputKeyCounter = this.getContext().getCounters().findCounter((Enum)TaskCounter.REDUCE_INPUT_GROUPS);
        this.inputValueCounter = this.getContext().getCounters().findCounter((Enum)TaskCounter.REDUCE_INPUT_RECORDS);
        this.shuffledInputs = this.getContext().getCounters().findCounter((Enum)TaskCounter.NUM_SHUFFLED_INPUTS);
        this.conf.setStrings("tez.runtime.framework.local.dirs", this.getContext().getWorkDirs());
        TezTaskAttemptID taskAttemptId = TezTaskAttemptID.fromString((String)RssTezUtils.uniqueIdentifierToAttemptId(this.getContext().getUniqueIdentifier()));
        TezVertexID tezVertexID = taskAttemptId.getTaskID().getVertexID();
        TezDAGID tezDAGID = tezVertexID.getDAGId();
        int sourceVertexId = this.conf.getInt("tez.rss.shuffle.source.vertex.id", -1);
        int destinationVertexId = this.conf.getInt("tez.rss.shuffle.destination.vertex.id", -1);
        if (sourceVertexId == -1) {
            throw new RssException("sourceVertexId should not be -1");
        }
        if (destinationVertexId == -1) {
            throw new RssException("destinationVertexId should not be -1");
        }
        this.shuffleId = RssTezUtils.computeShuffleId(tezDAGID.getId(), sourceVertexId, destinationVertexId);
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.getContext().getApplicationId(), (int)this.getContext().getDAGAttemptNumber());
        return Collections.emptyList();
    }

    public synchronized void start() throws IOException {
        if (!this.isStarted.get()) {
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            this.shuffle = this.createRssShuffle();
            this.shuffle.run();
            LinkedList<Event> pending = new LinkedList<Event>();
            this.pendingEvents.drainTo(pending);
            if (pending.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("NoAutoStart delay in processing first event: " + (System.currentTimeMillis() - this.firstEventReceivedTime));
                }
                this.shuffle.handleEvents(pending);
            }
            this.isStarted.set(true);
        }
    }

    @VisibleForTesting
    RssShuffle createRssShuffle() throws IOException {
        return new RssShuffle(this.getContext(), this.conf, this.getNumPhysicalInputs(), this.memoryUpdateCallbackHandler.getMemoryAssigned(), this.shuffleId, this.applicationAttemptId);
    }

    public synchronized boolean isInputReady() throws IOException, InterruptedException, TezException {
        Preconditions.checkState(this.isStarted.get(), "Must start input before invoking this method");
        if (this.getNumPhysicalInputs() == 0) {
            return true;
        }
        return this.shuffle.isInputReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInputReady() throws IOException, InterruptedException, TezException {
        RssShuffle localShuffleCopy = null;
        RssOrderedGroupedKVInput rssOrderedGroupedKVInput = this;
        synchronized (rssOrderedGroupedKVInput) {
            Preconditions.checkState(this.isStarted.get(), "Must start input before invoking this method");
            if (this.getNumPhysicalInputs() == 0) {
                return;
            }
            localShuffleCopy = this.shuffle;
        }
        TezRawKeyValueIterator localRawIter = localShuffleCopy.waitForInput();
        RssOrderedGroupedKVInput rssOrderedGroupedKVInput2 = this;
        synchronized (rssOrderedGroupedKVInput2) {
            this.rawIter = localRawIter;
            this.createValuesIterator();
        }
    }

    public synchronized List<Event> close() throws IOException {
        if (this.getNumPhysicalInputs() != 0 && this.rawIter != null) {
            this.rawIter.close();
        }
        if (this.shuffle != null) {
            this.shuffle.shutdown();
        }
        long dataSize = this.getContext().getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DECOMPRESSED).getValue();
        this.getContext().getStatisticsReporter().reportDataSize(dataSize);
        long inputRecords = this.getContext().getCounters().findCounter((Enum)TaskCounter.REDUCE_INPUT_RECORDS).getValue();
        this.getContext().getStatisticsReporter().reportItemsProcessed(inputRecords);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValuesReader getReader() throws IOException, TezException {
        TezRawKeyValueIterator rawIterLocal;
        RssOrderedGroupedKVInput rssOrderedGroupedKVInput = this;
        synchronized (rssOrderedGroupedKVInput) {
            rawIterLocal = this.rawIter;
            if (this.getNumPhysicalInputs() == 0) {
                return new KeyValuesReader(){

                    public boolean next() throws IOException {
                        RssOrderedGroupedKVInput.this.getContext().notifyProgress();
                        this.hasCompletedProcessing();
                        this.completedProcessing = true;
                        return false;
                    }

                    public Object getCurrentKey() throws IOException {
                        throw new RssException("No data available in Input");
                    }

                    public Iterable<Object> getCurrentValues() throws IOException {
                        throw new RssException("No data available in Input");
                    }
                };
            }
        }
        if (rawIterLocal == null) {
            try {
                this.waitForInputReady();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOInterruptedException("Interrupted while waiting for input ready", (Throwable)e);
            }
        }
        ValuesIterator valuesIter = null;
        RssOrderedGroupedKVInput rssOrderedGroupedKVInput2 = this;
        synchronized (rssOrderedGroupedKVInput2) {
            valuesIter = this.vIter;
        }
        return new OrderedGroupedKeyValuesReader(valuesIter, this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() throws ProgressFailedException, InterruptedException {
        int totalInputs = this.getNumPhysicalInputs();
        if (totalInputs != 0) {
            RssOrderedGroupedKVInput rssOrderedGroupedKVInput = this;
            synchronized (rssOrderedGroupedKVInput) {
                return 0.5f * (float)this.shuffledInputs.getValue() / (float)totalInputs + (this.rawIter != null ? 0.5f * this.rawIter.getProgress().getProgress() : 0.0f);
            }
        }
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List<Event> inputEvents) throws IOException {
        RssShuffle shuffleLocalRef;
        RssOrderedGroupedKVInput rssOrderedGroupedKVInput = this;
        synchronized (rssOrderedGroupedKVInput) {
            if (this.getNumPhysicalInputs() == 0) {
                throw new RssException("No input events expected as numInputs is 0");
            }
            if (!this.isStarted.get()) {
                if (this.firstEventReceivedTime == -1L) {
                    this.firstEventReceivedTime = System.currentTimeMillis();
                }
                this.pendingEvents.addAll(inputEvents);
                return;
            }
            shuffleLocalRef = this.shuffle;
        }
        shuffleLocalRef.handleEvents(inputEvents);
    }

    protected synchronized void createValuesIterator() throws IOException {
        RawComparator rawComparator = ConfigUtils.getIntermediateInputKeyComparator((Configuration)this.conf);
        Class keyClass = ConfigUtils.getIntermediateInputKeyClass((Configuration)this.conf);
        Class valClass = ConfigUtils.getIntermediateInputValueClass((Configuration)this.conf);
        LOG.info(this.getContext().getSourceVertexName() + ": creating ValuesIterator with comparator=" + rawComparator.getClass().getName() + ", keyClass=" + keyClass.getName() + ", valClass=" + valClass.getName());
        this.vIter = new ValuesIterator(this.rawIter, rawComparator, keyClass, valClass, this.conf, this.inputKeyCounter, this.inputValueCounter);
    }

    public RawComparator getInputKeyComparator() {
        return ConfigUtils.getIntermediateInputKeyComparator((Configuration)this.conf);
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(CONF_KEYS);
    }

    static {
        CONF_KEYS.add("tez.runtime.ifile.readahead");
        CONF_KEYS.add("tez.runtime.ifile.readahead.bytes");
        CONF_KEYS.add("io.file.buffer.size");
        CONF_KEYS.add("tez.runtime.io.sort.factor");
        CONF_KEYS.add("tez.runtime.combine.min.spills");
        CONF_KEYS.add("tez.runtime.combiner.class");
        CONF_KEYS.add("tez.runtime.shuffle.use.async.http");
        CONF_KEYS.add("tez.runtime.shuffle.parallel.copies");
        CONF_KEYS.add("tez.runtime.shuffle.fetch.failures.limit");
        CONF_KEYS.add("tez.runtime.shuffle.fetch.max.task.output.at.once");
        CONF_KEYS.add("tez.runtime.shuffle.notify.readerror");
        CONF_KEYS.add("tez.runtime.shuffle.connect.timeout");
        CONF_KEYS.add("tez.runtime.shuffle.keep-alive.enabled");
        CONF_KEYS.add("tez.runtime.shuffle.keep-alive.max.connections");
        CONF_KEYS.add("tez.runtime.shuffle.read.timeout");
        CONF_KEYS.add("tez.runtime.shuffle.buffersize");
        CONF_KEYS.add("tez.runtime.shuffle.ssl.enable");
        CONF_KEYS.add("tez.runtime.shuffle.fetch.verify-disk-checksum");
        CONF_KEYS.add("tez.runtime.shuffle.fetch.buffer.percent");
        CONF_KEYS.add("tez.runtime.shuffle.memory.limit.percent");
        CONF_KEYS.add("tez.runtime.shuffle.merge.percent");
        CONF_KEYS.add("tez.runtime.shuffle.memory-to-memory.segments");
        CONF_KEYS.add("tez.runtime.shuffle.memory-to-memory.enable");
        CONF_KEYS.add("tez.runtime.shuffle.src-attempt.abort.limit");
        CONF_KEYS.add("tez.runtime.shuffle.acceptable.host-fetch.failure.fraction");
        CONF_KEYS.add("tez.runtime.shuffle.min.failures.per.host");
        CONF_KEYS.add("tez.runtime.shuffle.max.stall.time.fraction");
        CONF_KEYS.add("tez.runtime.shuffle.max.allowed.failed.fetch.fraction");
        CONF_KEYS.add("tez.runtime.shuffle.min.required.progress.fraction");
        CONF_KEYS.add("tez.runtime.shuffle.failed.check.since-last.completion");
        CONF_KEYS.add("tez.runtime.shuffle.fetcher.use-shared-pool");
        CONF_KEYS.add("tez.runtime.task.input.post-merge.buffer.percent");
        CONF_KEYS.add("tez.runtime.group.comparator.class");
        CONF_KEYS.add("tez.runtime.key.comparator.class");
        CONF_KEYS.add("tez.runtime.key.class");
        CONF_KEYS.add("tez.runtime.value.class");
        CONF_KEYS.add("tez.runtime.compress");
        CONF_KEYS.add("tez.runtime.compress.codec");
        CONF_KEYS.add("tez.runtime.key.secondary.comparator.class");
        CONF_KEYS.add("tez.runtime.optimize.local.fetch");
        CONF_KEYS.add("tez.runtime.convert.user-payload.to.history-text");
        CONF_KEYS.add("tez.counters.max");
        CONF_KEYS.add("tez.counters.group-name.max-length");
        CONF_KEYS.add("tez.counters.counter-name.max-length");
        CONF_KEYS.add("tez.counters.max.groups");
        CONF_KEYS.add("tez.runtime.cleanup.files.on.interrupt");
        CONF_KEYS.add("tez.runtime.task.memory");
        CONF_KEYS.add("tez.am.shuffle.auxiliary-service.id");
    }

    private static class OrderedGroupedKeyValuesReader
    extends KeyValuesReader {
        private final ValuesIterator valuesIter;
        private final InputContext context;

        OrderedGroupedKeyValuesReader(ValuesIterator valuesIter, InputContext context) {
            this.valuesIter = valuesIter;
            this.context = context;
        }

        public boolean next() throws IOException {
            this.context.notifyProgress();
            return this.valuesIter.moveToNext();
        }

        public Object getCurrentKey() throws IOException {
            Object key = this.valuesIter.getKey();
            return key;
        }

        public Iterable<Object> getCurrentValues() throws IOException {
            return this.valuesIter.getValues();
        }
    }
}

