/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.uniffle.client.impl.TrackingBlockStatus;
import org.apache.uniffle.client.impl.TrackingPartitionStatus;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;

public class FailedBlockSendTracker {
    private Map<Long, List<TrackingBlockStatus>> trackingBlockStatusMap = Maps.newConcurrentMap();
    private final BlockingQueue<TrackingPartitionStatus> trackingNeedSplitPartitionStatusQueue = new LinkedBlockingQueue<TrackingPartitionStatus>();

    public void add(ShuffleBlockInfo shuffleBlockInfo, ShuffleServerInfo shuffleServerInfo, StatusCode statusCode) {
        this.trackingBlockStatusMap.computeIfAbsent(shuffleBlockInfo.getBlockId(), s -> Collections.synchronizedList(Lists.newArrayList())).add(new TrackingBlockStatus(shuffleBlockInfo, shuffleServerInfo, statusCode));
    }

    public void merge(FailedBlockSendTracker failedBlockSendTracker) {
        this.trackingBlockStatusMap.putAll(failedBlockSendTracker.trackingBlockStatusMap);
        this.trackingNeedSplitPartitionStatusQueue.addAll(failedBlockSendTracker.trackingNeedSplitPartitionStatusQueue);
    }

    public void remove(long blockId) {
        this.trackingBlockStatusMap.remove(blockId);
    }

    public void clearAndReleaseBlockResources() {
        this.trackingBlockStatusMap.values().forEach(l -> {
            List list = l;
            synchronized (list) {
                l.forEach(x -> x.getShuffleBlockInfo().executeCompletionCallback(false));
            }
        });
        this.trackingBlockStatusMap.clear();
        this.trackingNeedSplitPartitionStatusQueue.clear();
    }

    public Set<Long> getFailedBlockIds() {
        return this.trackingBlockStatusMap.keySet();
    }

    public List<TrackingBlockStatus> getFailedBlockStatus(Long blockId) {
        return this.trackingBlockStatusMap.get(blockId);
    }

    public Set<ShuffleServerInfo> getFaultyShuffleServers() {
        HashSet<ShuffleServerInfo> shuffleServerInfos = Sets.newHashSet();
        this.trackingBlockStatusMap.values().stream().forEach(l -> {
            List list = l;
            synchronized (list) {
                l.stream().forEach(status -> shuffleServerInfos.add(status.getShuffleServerInfo()));
            }
        });
        return shuffleServerInfos;
    }

    public void addNeedSplitPartition(int partitionId, ShuffleServerInfo shuffleServerInfo) {
        try {
            this.trackingNeedSplitPartitionStatusQueue.put(new TrackingPartitionStatus(partitionId, shuffleServerInfo));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RssException(e);
        }
    }

    public List<TrackingPartitionStatus> removeAllTrackedPartitions() {
        ArrayList<TrackingPartitionStatus> trackingPartitionStatusList = Lists.newArrayList();
        this.trackingNeedSplitPartitionStatusQueue.drainTo(trackingPartitionStatusList);
        return trackingPartitionStatusList;
    }

    public boolean isEmpty() {
        return this.trackingBlockStatusMap.isEmpty() && this.trackingNeedSplitPartitionStatusQueue.isEmpty();
    }
}

