/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;

public class HeartbeatRequest
extends AbstractRequest {
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String GROUP_GENERATION_ID_KEY_NAME = "group_generation_id";
    private static final String MEMBER_ID_KEY_NAME = "member_id";
    private final String groupId;
    private final int groupGenerationId;
    private final String memberId;

    private HeartbeatRequest(String groupId, int groupGenerationId, String memberId, short version) {
        super(version);
        this.groupId = groupId;
        this.groupGenerationId = groupGenerationId;
        this.memberId = memberId;
    }

    public HeartbeatRequest(Struct struct, short version) {
        super(version);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.groupGenerationId = struct.getInt(GROUP_GENERATION_ID_KEY_NAME);
        this.memberId = struct.getString(MEMBER_ID_KEY_NAME);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new HeartbeatResponse(Errors.forException(e));
            }
            case 1: {
                return new HeartbeatResponse(throttleTimeMs, Errors.forException(e));
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.HEARTBEAT.latestVersion()));
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupGenerationId() {
        return this.groupGenerationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public static HeartbeatRequest parse(ByteBuffer buffer, short version) {
        return new HeartbeatRequest(ApiKeys.HEARTBEAT.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.HEARTBEAT.requestSchema(this.version()));
        struct.set(GROUP_ID_KEY_NAME, (Object)this.groupId);
        struct.set(GROUP_GENERATION_ID_KEY_NAME, (Object)this.groupGenerationId);
        struct.set(MEMBER_ID_KEY_NAME, (Object)this.memberId);
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<HeartbeatRequest> {
        private final String groupId;
        private final int groupGenerationId;
        private final String memberId;

        public Builder(String groupId, int groupGenerationId, String memberId) {
            super(ApiKeys.HEARTBEAT);
            this.groupId = groupId;
            this.groupGenerationId = groupGenerationId;
            this.memberId = memberId;
        }

        @Override
        public HeartbeatRequest build(short version) {
            return new HeartbeatRequest(this.groupId, this.groupGenerationId, this.memberId, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=HeartbeatRequest").append(", groupId=").append(this.groupId).append(", groupGenerationId=").append(this.groupGenerationId).append(", memberId=").append(this.memberId).append(")");
            return bld.toString();
        }
    }
}

