/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import java.util.List;
import java.util.Locale;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractMapper
implements IRequestMapper {
    protected String getPlaceholder(String s) {
        return this.getPlaceholder(s, '$');
    }

    protected String getOptionalPlaceholder(String s) {
        return this.getPlaceholder(s, '#');
    }

    protected String getPlaceholder(String s, char startChar) {
        if (s == null || s.length() < 4) {
            return null;
        }
        if (s.charAt(0) != startChar || s.charAt(1) != '{' || s.charAt(s.length() - 1) != '}') {
            return null;
        }
        return s.substring(2, s.length() - 1);
    }

    protected boolean urlStartsWith(Url url, String ... segments) {
        if (url == null) {
            return false;
        }
        List<String> urlSegments = url.getSegments();
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            String urlSegment = this.safeSegmentGetter(urlSegments, i, null);
            if (urlSegment == null && this.getOptionalPlaceholder(segment) == null) {
                return false;
            }
            if (segment.equals(urlSegment) || this.getPlaceholder(segment) != null || this.getOptionalPlaceholder(segment) != null) continue;
            return false;
        }
        return true;
    }

    protected String safeSegmentGetter(List<String> segments, int index, String defaultValue) {
        if (index < segments.size()) {
            return segments.get(index);
        }
        return defaultValue;
    }

    protected PageParameters extractPageParameters(Request request, int segmentsToSkip, IPageParametersEncoder encoder) {
        Args.notNull(request, "request");
        Args.notNull(encoder, "encoder");
        Url urlCopy = new Url(request.getUrl());
        while (segmentsToSkip > 0 && !urlCopy.getSegments().isEmpty()) {
            urlCopy.getSegments().remove(0);
            --segmentsToSkip;
        }
        if (!urlCopy.getQueryParameters().isEmpty() && Strings.isEmpty(urlCopy.getQueryParameters().get(0).getValue())) {
            this.removeMetaParameter(urlCopy);
        }
        return encoder.decodePageParameters(urlCopy);
    }

    protected void removeMetaParameter(Url urlCopy) {
    }

    protected Url encodePageParameters(Url url, PageParameters pageParameters, IPageParametersEncoder encoder) {
        Url parametersUrl;
        Args.notNull(url, "url");
        Args.notNull(encoder, "encoder");
        if (pageParameters == null) {
            pageParameters = new PageParameters();
        }
        if ((parametersUrl = encoder.encodePageParameters(pageParameters)) != null) {
            url = new Url(url);
            for (String s : parametersUrl.getSegments()) {
                url.getSegments().add(s);
            }
            for (Url.QueryParameter p : parametersUrl.getQueryParameters()) {
                url.getQueryParameters().add(p);
            }
        }
        return url;
    }

    protected String[] getMountSegments(String mountPath) {
        if (mountPath.charAt(0) == '/') {
            mountPath = mountPath.substring(1);
        }
        Url url = Url.parse(mountPath);
        String[] res = new String[url.getSegments().size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = url.getSegments().get(i);
        }
        return res;
    }

    protected Locale resolveLocale() {
        return Locale.getDefault(Locale.Category.DISPLAY);
    }
}

