/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import io.vertx.core.Vertx;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.sidecar.client.HttpClient;
import org.apache.cassandra.sidecar.client.RequestExecutor;
import org.apache.cassandra.sidecar.client.VertxHttpClient;

public class VertxRequestExecutor
extends RequestExecutor {
    private final Vertx vertx;

    public VertxRequestExecutor(VertxHttpClient httpClient) {
        super((HttpClient)httpClient);
        this.vertx = Objects.requireNonNull(httpClient.vertx(), "The vertx instance is required");
    }

    protected void schedule(long delayMillis, Runnable runnable) {
        if (delayMillis > 0L) {
            this.vertx.setTimer(delayMillis, p -> runnable.run());
        } else {
            runnable.run();
        }
    }

    public void close() throws Exception {
        super.close();
        try {
            this.vertx.close().toCompletionStage().toCompletableFuture().get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.logger.warn("Failed to close vertx after 1 minute", (Throwable)exception);
        }
    }
}

