/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Reclaimer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private Reclaimer() {
    }

    public static void scan(JournalFile[] files) {
        for (int i = 0; i < files.length; ++i) {
            JournalFile currentFile = files[i];
            if (!currentFile.isNegReclaimCriteria()) {
                boolean outstandingNeg = false;
                for (int j = i - 1; j >= 0 && !outstandingNeg; --j) {
                    JournalFile file = files[j];
                    if (file.isCanReclaim() || currentFile.getNegCount(file) == 0) continue;
                    logger.trace("{} can't be reclaimed because {} has negative values", (Object)currentFile, (Object)file);
                    outstandingNeg = true;
                }
                if (outstandingNeg) continue;
                currentFile.setNegReclaimCriteria();
            }
            if (currentFile.isPosReclaimCriteria()) continue;
            int negCount = 0;
            int posCount = currentFile.getPosCount();
            logger.trace("posCount on {} = {}", (Object)currentFile, (Object)posCount);
            for (int j = i; j < files.length && negCount < posCount; ++j) {
                int toNeg = files[j].getNegCount(currentFile);
                negCount += toNeg;
                if (!logger.isTraceEnabled() || toNeg == 0) continue;
                logger.trace("Negative from {} into {} = {}", new Object[]{files[j], currentFile, toNeg});
            }
            if (negCount < posCount) {
                logger.trace("{} can't be reclaimed because there are not enough negatives {}", (Object)currentFile, (Object)negCount);
                continue;
            }
            logger.trace("{} can be reclaimed", (Object)currentFile);
            currentFile.setPosReclaimCriteria();
        }
    }
}

