/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Map;
import java.util.TreeMap;

public enum QueueField {
    ID("id"),
    NAME("name"),
    CONSUMER_ID("consumerID"),
    ADDRESS("address"),
    MAX_CONSUMERS("maxConsumers"),
    FILTER("filter"),
    MESSAGE_COUNT("messageCount"),
    CONSUMER_COUNT("consumerCount"),
    DELIVERING_COUNT("deliveringCount"),
    MESSAGES_ADDED("messagesAdded"),
    MESSAGES_ACKED("messagesAcked"),
    MESSAGES_EXPIRED("messagesExpired"),
    ROUTING_TYPE("routingType"),
    USER("user"),
    AUTO_CREATED("autoCreated"),
    DURABLE("durable"),
    PAUSED("paused"),
    PERSISTEDPAUSE("persistedPause"),
    TEMPORARY("temporary"),
    PURGE_ON_NO_CONSUMERS("purgeOnNoConsumers"),
    MESSAGES_KILLED("messagesKilled"),
    DIRECT_DELIVER("directDeliver"),
    LAST_VALUE("lastValue"),
    EXCLUSIVE("exclusive"),
    SCHEDULED_COUNT("scheduledCount"),
    LAST_VALUE_KEY("lastValueKey"),
    GROUP_REBALANCE("groupRebalance"),
    GROUP_REBALANCE_PAUSE_DISPATCH("groupRebalancePauseDispatch"),
    GROUP_BUCKETS("groupBuckets"),
    GROUP_FIRST_KEY("groupFirstKey"),
    ENABLED("enabled"),
    RING_SIZE("ringSize"),
    CONSUMERS_BEFORE_DISPATCH("consumersBeforeDispatch"),
    DELAY_BEFORE_DISPATCH("delayBeforeDispatch"),
    AUTO_DELETE("autoDelete"),
    INTERNAL_QUEUE("internalQueue");

    private static final Map<String, QueueField> lookup;
    private final String name;

    public String getName() {
        return this.name;
    }

    private QueueField(String name) {
        this.name = name;
    }

    public static QueueField valueOfName(String name) {
        return lookup.get(name);
    }

    static {
        lookup = new TreeMap<String, QueueField>(String.CASE_INSENSITIVE_ORDER);
        for (QueueField e : QueueField.values()) {
            lookup.put(e.name, e);
        }
    }
}

